/*
 *
 *                             C@@o         ____  _____   __ _
 *                        oC8@@@@@@@o      |___ \|  __ \ / _| |
 *                    o@@@@@@@@@@@@O         __) | |  | | |_| | _____      __
 *         O@O        8@@@@@@@@@O           |__ <| |  | |  _| |/ _ \ \ /\ / /
 *       o@@@@@@@O    OOOOOCo               ___) | |__| | | | | (_) \ V  V /
 *       C@@@@@@@@@@@@Oo                   |____/|_____/|_| |_|\___/ \_/\_/
 *          o8@@@@@@@@@@@@@@@@8OOCCCC
 *              oO@@@@@@@@@@@@@@@@@@@o          3Dflow s.r.l. - www.3dflow.net
 *                   oO8@@@@@@@@@@@@o           Copyright 2022
 *       oO88@@@@@@@@8OCo                       All Rights Reserved
 *  O@@@@@@@@@@@@@@@@@@@@@@@@@8OCCoooooooCCo
 *   @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@O
 *    @@@Oo            oO8@@@@@@@@@@@@@@@@8
 *
 */

#ifndef FLOWENGINEPROGRESSBAR_H
#define FLOWENGINEPROGRESSBAR_H

#pragma once

namespace FlowEngine
{
    /*!
     * @brief Pure virtual Progress Bar interface
     *
     * Pure virtual progress bar interface. Override for your own gui.
     */
    class ProgressBarInterface
    {
        public:

            //! Default virtual destructor
            virtual ~ProgressBarInterface() = default;

        public:

            //! Show the progress bar
            //! @param nWindowTitle a pointer to a null terminated string that names the main task
            //! @param nShowGlobalProgress when true, the progress is split in `main` and `secondary` tasks
            //! @param nShowCancelButton when true, the running task is cancellable
            virtual void start( const char *nWindowTitle, bool nShowGlobalProgress, bool nShowCancelButton ) = 0;

            //! Hide the loading bar
            virtual void finish() = 0;

            //! Set progress bar ticks and reset the counter to 0
            //! @param nTicks the number of steps to take in order for the task to finish.
            //!               when set to 0, the task has an `indefinite` number of steps
            //! @param nLoadingText pointer to a null terminated string that names the current task phase
            virtual void resetTicks( unsigned int nTicks, const char *nLoadingText ) = 0;

            //! Set global progress bar ticks (if any) and reset the counter to 0
            //! @param nGlobalTicks the number of steps to take in order for the main task to finish.
            //!                     when set to 0, the main task has an `indefinite` number of steps
            //! @param nLoadingText pointer to a null terminated string that names the current main task phase
            virtual void resetGlobalTicks( unsigned int nGlobalTicks, const char *nLoadingText ) = 0;

            //! Progress the loading bar - Add + 1 Tick
            virtual void update() = 0;

            //! Progress the global progress bar - Add + 1 Tick
            virtual void updateGlobal() = 0;
    };
}

#endif
