/*
 *
 *                             C@@o         ____  _____   __ _
 *                        oC8@@@@@@@o      |___ \|  __ \ / _| |
 *                    o@@@@@@@@@@@@O         __) | |  | | |_| | _____      __
 *         O@O        8@@@@@@@@@O           |__ <| |  | |  _| |/ _ \ \ /\ / /
 *       o@@@@@@@O    OOOOOCo               ___) | |__| | | | | (_) \ V  V /
 *       C@@@@@@@@@@@@Oo                   |____/|_____/|_| |_|\___/ \_/\_/
 *          o8@@@@@@@@@@@@@@@@8OOCCCC
 *              oO@@@@@@@@@@@@@@@@@@@o          3Dflow s.r.l. - www.3dflow.net
 *                   oO8@@@@@@@@@@@@o           Copyright 2022
 *       oO88@@@@@@@@8OCo                       All Rights Reserved
 *  O@@@@@@@@@@@@@@@@@@@@@@@@@8OCCoooooooCCo
 *   @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@O
 *    @@@Oo            oO8@@@@@@@@@@@@@@@@8
 *
 */

#ifndef FLOWENGINEDYNAMICBUFFERINTERFACE_H
#define FLOWENGINEDYNAMICBUFFERINTERFACE_H

#pragma once

#include "CommonDef.h"

namespace FlowEngine
{
    //! Dynamic memory buffer utility used to marshall variable amount of data.
    class DynamicBufferInterface
    {
        public:

            //! Default virtual destructor.
            FLE_DLL virtual ~DynamicBufferInterface() = default;

        public:

            //! Set the content of the buffer. Data is copied.
            //! @param buffer a buffer containing the data to be copied.
            //! @returns One of the following result codes:
            //! - Result::Success -- if the data was successfully copied from the buffer.
            //! - Result::InvalidArgument -- if `buffer` is not a valid buffer.
            //! - Result::OutOfMemoryError -- if the system reported a bad memory allocation.
            FLE_DLL virtual Result setContent( ConstBuffer< char > buffer ) = 0;

            //! @returns the size of the buffer.
            FLE_DLL virtual Size getContentSize() const = 0;

            //! Copies the content of the buffer to the supplied buffer.
            //! @param buffer a buffer that will receive the data.
            //! @returns One of the following result codes:
            //! - Result::Success -- if the data was successfully copied to the buffer.
            //! - Result::InvalidArgument -- if `buffer` is not a valid buffer.
            //! - Result::BufferTooSmall -- if `buffer` is not big enough to receive all data. See getContentSize.
            FLE_DLL virtual Result getContent( Buffer< char > buffer ) const = 0;
    };

    //! Creates a DynamicBuffer object
    //! @returns a new DynamicBuffer object or nullptr if the operation failed
    FLOWENGINE_FACTORY DynamicBufferInterface *CreateDynamicBuffer();

    //! Destroys a DynamicBuffer object
    //! @param[in] buf pointer to a DynamicBuffer created with CreateDynamicBuffer()
    FLOWENGINE_FACTORY void DestroyDynamicBuffer( DynamicBufferInterface *buf );
}

#endif
