/*
 *
 *                             C@@o         ____  _____   __ _
 *                        oC8@@@@@@@o      |___ \|  __ \ / _| |
 *                    o@@@@@@@@@@@@O         __) | |  | | |_| | _____      __
 *         O@O        8@@@@@@@@@O           |__ <| |  | |  _| |/ _ \ \ /\ / /
 *       o@@@@@@@O    OOOOOCo               ___) | |__| | | | | (_) \ V  V /
 *       C@@@@@@@@@@@@Oo                   |____/|_____/|_| |_|\___/ \_/\_/
 *          o8@@@@@@@@@@@@@@@@8OOCCCC
 *              oO@@@@@@@@@@@@@@@@@@@o          3Dflow s.r.l. - www.3dflow.net
 *                   oO8@@@@@@@@@@@@o           Copyright 2022
 *       oO88@@@@@@@@8OCo                       All Rights Reserved
 *  O@@@@@@@@@@@@@@@@@@@@@@@@@8OCCoooooooCCo
 *   @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@O
 *    @@@Oo            oO8@@@@@@@@@@@@@@@@8
 *
 */

#pragma once

#include <string>
#include <vector>

namespace FlowEngine
{
    class CameraInterface;
    class StereoTexturedMeshInterface;
}

namespace fbxsdk
{
    class FbxScene;
    class FbxNode;
}

class FbxHelper
{
    public:

        FbxHelper() = default;
        ~FbxHelper();

    public:

        void addCamera( const FlowEngine::CameraInterface *camera );

        void addStereoTexturedMesh( const FlowEngine::StereoTexturedMeshInterface *texturedMesh );

    public:

        void setRotation( double angle0, double angle1, double angle2 );
        void setScale( double scale );

    public:

        bool saveTo( const std::string &filePath ) const;

    private:

        bool createCameraNode( fbxsdk::FbxScene *scene,
                               fbxsdk::FbxNode *parentNode,
                               const FlowEngine::CameraInterface *camera ) const;

        bool createTexturedMeshNode( fbxsdk::FbxScene *scene,
                                     fbxsdk::FbxNode *parentNode,
                                     const FlowEngine::StereoTexturedMeshInterface *texturedMesh ) const;

    private:

        std::vector< const FlowEngine::CameraInterface * >             mCameras;
        std::vector< const FlowEngine::StereoTexturedMeshInterface * > mStereoTexturedMeshes;

    private:

        mutable std::vector< std::string > mTempFiles;

        double mRotAngle0 = 0.0;
        double mRotAngle1 = 0.0;
        double mRotAngle2 = 0.0;

        double mScale = 1.0;
};
