/*
 *
 *                             C@@o         ____  _____   __ _
 *                        oC8@@@@@@@o      |___ \|  __ \ / _| |
 *                    o@@@@@@@@@@@@O         __) | |  | | |_| | _____      __
 *         O@O        8@@@@@@@@@O           |__ <| |  | |  _| |/ _ \ \ /\ / /
 *       o@@@@@@@O    OOOOOCo               ___) | |__| | | | | (_) \ V  V /
 *       C@@@@@@@@@@@@Oo                   |____/|_____/|_| |_|\___/ \_/\_/
 *          o8@@@@@@@@@@@@@@@@8OOCCCC
 *              oO@@@@@@@@@@@@@@@@@@@o          3Dflow s.r.l. - www.3dflow.net
 *                   oO8@@@@@@@@@@@@o           Copyright 2022
 *       oO88@@@@@@@@8OCo                       All Rights Reserved
 *  O@@@@@@@@@@@@@@@@@@@@@@@@@8OCCoooooooCCo
 *   @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@O
 *    @@@Oo            oO8@@@@@@@@@@@@@@@@8
 *
 */

#ifndef FLOWENGINELOGLISTENER_H
#define FLOWENGINELOGLISTENER_H

#pragma once

namespace FlowEngine
{
    //! Enumerates the possible types of a log
    enum class LogType
    {
        Normal,
        Warning,
        Error,
        Info
    };

    /*!
     * @brief Pure virtual Log Listener interface
     *
     * Child classes need just to override the method messageLogged (called when a message is logged by the logger)
     */
    class LogListenerInterface
    {
        public:

            //! Default virtual destructor
            virtual ~LogListenerInterface() = default;

        public:

            //! Called when a new message is logged
            //! @param nMessage pointer to a null terminated string containing the text of the message
            virtual void messageLogged( const char *nMessage ) = 0;

            //! Called when the current log type has changed
            //! @param type the new log type
            virtual void typeChanged( LogType type ) { }
    };
}

#endif
