###############################################################################
# Find FlowEngine
#
# This sets the following variables:

# FLOWENGINE_FOUND - True if package was found.
# FLOWENGINE_INCLUDE_DIRS - Directories containing the include files. 
# FLOWENGINE_LIBRARIES - to link dynamically.

# Not strictly necessary: 
# FLOWENGINE_DEFINITIONS - Compiler flags for FlowEngine.
# FLOWENGINE_VERSION - Package version

find_package(PkgConfig QUIET)

# -- Paths

if ( "${CMAKE_CXX_COMPILER_ID}" STREQUAL "GNU" )
    set(CMAKE_INCLUDE_PATH ${CMAKE_INCLUDE_PATH} /usr /usr/local)
endif()

# redundant to the env var.
set(paths 
    "C:/SDK/FlowEngine" 
    "C:/SDK/FlowEngine/include"
    "C:/SDK/FlowEngine/bin"
    "C:/SDK/FlowEngine/lib"
    )

set(suffixes 

    "FlowEngine"
    "include"          # to find include folder
    
    "bin"
    "FlowEngine/bin"
    
    "redist"
    "FlowEngine/redist"
    
    "lib"              # to Find Library
    "FlowEngine/lib"
    
    )

# -- Include dir 

find_path(FLOWENGINE_INCLUDE_DIR FlowEngine # name of the folder that lays inside the include dir
    # HINTS $ENV{FLOW_ENGINE_DIR} 
    PATHS  ${paths}  
    PATH_SUFFIXES ${suffixes} )

set(FLOWENGINE_INCLUDE_DIRS ${FLOWENGINE_INCLUDE_DIR})

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(FlowEngine DEFAULT_MSG FLOWENGINE_INCLUDE_DIR)

# -- Find Library

find_library(FLOWENGINE_LIB 
    NAMES FlowEngine.lib FlowEngine.so 
    # HINTS $ENV{FLOW_ENGINE_DIR}  
    PATHS ${paths}
    PATH_SUFFIXES ${suffixes} )

set(FLOWENGINE_LIBRARIES ${FLOWENGINE_LIB} )

# -- Set found version, if any 

if(FLOWENGINE_INCLUDE_DIR)

    # read from CMakeLists.txt 
    message(STATUS "File searched: ${FLOWENGINE_INCLUDE_DIR}/../CMakeLists.txt")
    file(READ "${FLOWENGINE_INCLUDE_DIR}/../CMakeLists.txt" _FlowEngineVersionFile) 

    string(REGEX MATCH "FLOW_VERSION_MAJOR[ \t]+([0-9])" _Major "${_FlowEngineVersionFile}") 
    set(VERSION_MAJOR "${CMAKE_MATCH_1}")
    string(REGEX MATCH "FLOW_VERSION_MINOR[ \t]+([0-9])" _Minor "${_FlowEngineVersionFile}") 
    set(VERSION_MINOR "${CMAKE_MATCH_1}")
    string(REGEX MATCH "FLOW_VERSION_BUILD[ \t]+([0-9])" _Build "${_FlowEngineVersionFile}")
    set(VERSION_BUILD "${CMAKE_MATCH_1}")
    string(REGEX MATCH "FLOW_VERSION_REVISION[ \t]+([0-9])" _Revision "${_FlowEngineVersionFile}")
    set(VERSION_REVISION "${CMAKE_MATCH_1}")

    set(VERSION_STRING  ${VERSION_MAJOR}.${VERSION_MINOR}.${VERSION_BUILD}.${VERSION_REVISION})  

    set(FLOWENGINE_VERSION ${VERSION_STRING})

endif(FLOWENGINE_INCLUDE_DIR)


# -- Final msg

if(FLOWENGINE_FOUND)
  message(STATUS "FlowEngine found.")
  message(STATUS "Version: ${FLOWENGINE_VERSION}")
  message(STATUS "Include folder: ${FLOWENGINE_INCLUDE_DIRS}")
  message(STATUS "Library folder: ${FLOWENGINE_LIBRARIES}")
else()
  message(STATUS "FlowEngine was not found.")
  message(STATUS "For Windows build, please set the environment variable FLOW_ENGINE_DIR to the specific folder path of FlowEngine (e.g. C:/SDK/FlowEngine/ , using backslashes).")
endif()

if(${FLOWENGINE_VERSION} LESS ${RequiredVersion})
    message(SEND_ERROR "Cmake found an older version of FlowEngine. Required version: ${RequiredVersion} ; Found version: ${FLOWENGINE_VERSION} ") 
endif() 