/*
 *
 *                             C@@o         ____  _____   __ _
 *                        oC8@@@@@@@o      |___ \|  __ \ / _| |
 *                    o@@@@@@@@@@@@O         __) | |  | | |_| | _____      __
 *         O@O        8@@@@@@@@@O           |__ <| |  | |  _| |/ _ \ \ /\ / /
 *       o@@@@@@@O    OOOOOCo               ___) | |__| | | | | (_) \ V  V /
 *       C@@@@@@@@@@@@Oo                   |____/|_____/|_| |_|\___/ \_/\_/
 *          o8@@@@@@@@@@@@@@@@8OOCCCC
 *              oO@@@@@@@@@@@@@@@@@@@o          3Dflow s.r.l. - www.3dflow.net
 *                   oO8@@@@@@@@@@@@o           Copyright 2022
 *       oO88@@@@@@@@8OCo                       All Rights Reserved
 *  O@@@@@@@@@@@@@@@@@@@@@@@@@8OCCoooooooCCo
 *   @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@O
 *    @@@Oo            oO8@@@@@@@@@@@@@@@@8
 *
 */

#pragma once

#include "CommonDef.h"

namespace FlowEngine
{
    class CameraInterface;
    class BoundingBoxInterface;
    class ProgressBarInterface;

    class WorkspaceExportUtils
    {
        public:

            enum class ImageDistortionType
            {
                Distorted,
                Undistorted,
                UndistortedInternal,
                UndistortedFull
            };

            //! Exports a set of cameras to a nerf file structure (json + images folder).
            //! @param[in] path the base directory where to save the data. A 'json-nerf' subfolder will be created inside this directory.
            //! @param[in] cameras a buffer of pointers to the cameras to export.
            //! @param[in] camerasOffset a buffer of 2D offsets to be applied to each camera center before exporting.
            //!            Pass an empty buffer for no offsets.
            //!            When specified, the size of this buffer must match the size of `cameras`.
            //! @param[in] distortionType the type of distortion to apply to the exported images.
            //! @param[in] imageScale a scale factor to apply to the exported images. Use 1.0 for no scaling.
            //! @param[in] boundingBox the bounding box to export.
            //! @param[in] progressBar an optional progress bar to update during the export process.
            //! @returns One of the following result codes:
            //!  - Result::Success -- if the export was successful.
            //!  - Result::InvalidArgument --
            //!    - if `path` is not a valid string buffer or the directory does not exist.
            //!    - if `cameras` is empty or contains null pointers.
            //!    - if `camerasOffset` is not empty and its size does not match the size of `cameras`.
            //!  - Result::DiskWriteError -- if the operating system reported a write error.
            //!  - Result::GenericError -- if any other error occurred. Check the log for more information.
            static FLE_DLL Result exportJsonNerf( ConstStringBuffer path,
                                                  ConstBuffer< CameraInterface * > cameras,
                                                  ConstBuffer< Point2 > camerasOffset,
                                                  ImageDistortionType distortionType,
                                                  double imageScale,
                                                  const BoundingBoxInterface &boundingBox,
                                                  ProgressBarInterface &progressBar );
    };
}
